﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Web_Files_Enhanced
{
    public partial class NewFileForm : Form
    {
        private string _siteDir;

        public NewFileForm(string siteDir)
        {
            InitializeComponent();
            _siteDir = siteDir;
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            string ext = Path.GetExtension(txtFileName.Text);
            string fileName = _siteDir + '\\' + Misc.MakeStringFilenameSafe(txtFileName.Text);

            if (ext == ".html" || ext == ".htm")
            {
                string message = "Would you like to insert a HTML template int your document?";
                DialogResult result = MessageBox.Show(message, Application.ProductName, 
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question);

                if (result == DialogResult.Yes)
                {
                    string templateData = File.ReadAllText("template.dat");
                    File.WriteAllText(fileName, templateData);
                }
                else if (result == DialogResult.No)
                {
                    File.WriteAllText(fileName, string.Empty);
                }
            }
            else
            {
                File.WriteAllText(fileName, string.Empty);
            }

            this.Close();
        }

        private void bttnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void tbFileName_TextChanged(object sender, EventArgs e)
        {
            bttnOk.Enabled = (Path.HasExtension(txtFileName.Text));
        }

        public string SafeFileName
        {
            get { return Misc.MakeStringFilenameSafe(txtFileName.Text); }
        }
    }
}
